CapabilityEvents.blockEntity(event=>{
    event.attach("create:table_cloth",CapabilityBuilder.ITEM.blockEntity()
    .availableOn((be,dir)=>true)
    .extractItem((be,slot,amount,simulate)=>{
        let item=be.manuallyAddedItems[slot]
        if(!simulate&&item!=null){
            be.manuallyAddedItems.remove(slot)
            be.notifyUpdate()
        }
        return item;
    })
    .insertItem(
        /**
         * 
         * @param {*} be 
         * @param {*} slot 
         * @param {Internal.ItemStack} stack 
         * @param {*} simulate 
         * @returns 
         */
        (be,slot,stack,simulate)=>{
        if(be.isShop())return stack;
        if(be.manuallyAddedItems[slot])return stack;
        if(!simulate){
            be.manuallyAddedItems.add(stack.copyWithCount(1));
            be.notifyUpdate()
        }
        return stack.copyWithCount(stack.count-1);
    })
    .getSlotLimit((be,slot)=>1)
    .getSlots(be=>4)
    .getStackInSlot((be,slot)=>{
        if(be.manuallyAddedItems[slot]!=null)return be.manuallyAddedItems[slot];
        return Item.of("minecraft:air")
    })
    .isItemValid((be,slot,stack)=>true)
)
})
StartupEvents.registry("block",event=>{
    event.create("lavaspring")
    .tagBlock('minecraft:mineable/pickaxe')
    .lightLevel(1)
    .textureAll("kubejs:block/lavaspring")
    .textureSide("up","kubejs:block/spring_top")
    .textureSide("down","kubejs:block/spring_top")
    .stoneSoundType()
    .blockEntity(entity=>{
        entity.attachCapability(
            CapabilityBuilder.FLUID.customBlockEntity()
            .onDrain((be,fluid,simu)=>{
                return fluid.amount
            })
            .getCapacity(be=>2147483647)
            .getFluid(be=>Fluid.lava(2147483647))
            .availableOn(be=>true)
        )
    })
    event.create("waterspring")
    .tagBlock('minecraft:mineable/pickaxe')
    .textureAll("kubejs:block/waterspring")
    .textureSide("up","kubejs:block/spring_top")
    .textureSide("down","kubejs:block/spring_top")
    .stoneSoundType()
    .blockEntity(entity=>{
        entity.attachCapability(
            CapabilityBuilder.FLUID.customBlockEntity()
            .onDrain((be,fluid,simu)=>{
                return fluid.amount
            })
            .getCapacity(be=>2147483647)
            .getFluid(be=>Fluid.water(2147483647))
            .availableOn(be=>true)
        )
    })
    event.create("magic_sand")
    .tagBlock('minecraft:mineable/shovel')
    .sandSoundType()
    .textureAll("kubejs:block/magic_sand")
    .blockEntity(entity=>{
        entity.serverTick(1, 0, (entity) => {
            let level=entity.level
            let egg=level.getBlock(entity.blockPos.above())
            if(egg.id=="minecraft:turtle_egg")egg.getBlockState().randomTick(level,egg.getPos(),level.getRandom())
        })
    })
})
StartupEvents.registry("fluid",event=>{
    event.create('bbq_sauce').stillTexture('kubejs:fluid/sauce_still').noBlock().noBucket().color(0x663931)
    event.create('ancient_sauce').stillTexture('kubejs:fluid/sauce_still').noBlock().noBucket().color(0x7aacc5)
    event.create('blaze_sauce').stillTexture('kubejs:fluid/sauce_still').noBlock().noBucket().color(0xfc9702)
    event.create('lime_sauce').stillTexture('kubejs:fluid/sauce_still').noBlock().noBucket().color(0xb4f213)
    event.create('pepper_sauce').stillTexture('kubejs:fluid/sauce_still').noBlock().noBucket().color(0xfa5023)
    
    event.create('pomegranate_sauce').stillTexture('kubejs:fluid/sauce_still').noBlock().noBucket().color(0xea386a)
    event.create('seafood_sauce').stillTexture('kubejs:fluid/sauce_still').noBlock().noBucket().color(0xffa08f)
    event.create('urchin_sauce').stillTexture('kubejs:fluid/sauce_still').noBlock().noBucket().color(0xd29f60)

    event.create('pizza_sauce_alfredo').stillTexture('kubejs:fluid/sauce_still').noBlock().noBucket().color(0xfaece0)
    event.create('pizza_sauce_blaze').stillTexture('kubejs:fluid/sauce_still').noBlock().noBucket().color(0xfc6900)
    event.create('pizza_sauce_seafood').stillTexture('kubejs:fluid/sauce_still').noBlock().noBucket().color(0xfadbbd)
    event.create('pizza_sauce_tomato').stillTexture('kubejs:fluid/sauce_still').noBlock().noBucket().color(0xbe331f)
    event.create('pizza_sauce_torch').stillTexture('kubejs:fluid/sauce_still').noBlock().noBucket().color(0xce3014)

    event.create('ender_sauce').stillTexture('kubejs:fluid/sauce_still').noBlock().noBucket().color(0xa547a4)
})